<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserCollection;
use App\Http\Resources\User\UserResource;
use App\sys\ApiResponse;
use App\sys\Services\User\UserService;
use Illuminate\Http\Request;

class UserController extends Controller
{
    // استخدام الـ Trait الخاص بالـ API
    use ApiResponse;

    protected $userService;

    /**
     * UserController constructor.
     */
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
    }

    /**
     * Store a newly created user in storage.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $users = $this->userService->getPaginated();

        return $this->apiResponse(200, 'success', null, new UserCollection($users));
    }

    public function store(Request $request)
    {
        $user = $this->userService->create($request->all());
        if (! $user) {
            $errors = $this->userService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        $user->load([
            'role',
            'groups',
            'services',
            'accommodations',
            'companies',
            'account_mappings.currency',
            'account_mappings.commissionAccount',
            'account_mappings.walletAccount',
            'account_mappings.supplierAccount',
        ]);

        return $this->apiResponse(200, 'success', null, new UserResource($user));
    }

    public function show($id)
    {
        $user = $this->userService->get($id);

        if (! $user) {
            $errors = $this->userService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        // الريبوزيتوري قام بعمل load لكل العلاقات بالفعل
        return $this->apiResponse(200, 'success', null, new UserResource($user));
    }

    public function update(Request $request, $id)
    {
        $user = $this->userService->update($id, $request->all());

        if (! $user) {
            $errors = $this->userService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        // تحميل كل العلاقات بعد التحديث لضمان عرضها
        $user->load(
            'role', 'groups', 'services', 'accommodations', 'companies',
            'account_mappings.currency',
            'account_mappings.commissionAccount',
            'account_mappings.walletAccount'
        );

        return $this->apiResponse(200, 'success', null, new UserResource($user));
    }

    public function destroy($id)
    {
        $result = $this->userService->delete($id);

        if (! $result) {
            $errors = $this->userService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'Users Deleted Successuflly', null);
    }

    public function updateOverrides(Request $request, $id)
    {

        $overridesData = $request->input('overrides', []);

        // [تعديل] إرسال $id مباشرة
        $response = $this->userService->updateOverrides($id, $overridesData);

        if (! $response) {
            $errors = $this->userService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function updateuserrole(Request $request, $id)
    {

        $roleId = $request->input('role_id');

        $response = $this->userService->updateUserRole($id, $roleId);

        if (! $response) {
            $errors = $this->userService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'User role updated successfully', null);
    }
}
