<?php

namespace App\Http\Resources\Accommodation;

use Illuminate\Http\Resources\Json\JsonResource;

class AccommodationsTranslationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'lang_id' => $this->lang_id,
            'lang_name' => $this->getLang->name ?? null,
            'lang_code' => $this->getLang->code ?? null,
            'accommodation_id' => $this->accommodation_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
