<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CityResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'country_id' => $this->country_id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'country_name' => $this->country->name ?? null,
            'active' => $this->is_active,
            'short_cut' => $this->shortcut,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
