<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class AccommodationReservationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id,
            'accommodation_id' => $this->accommodation_id,
            'type' => $this->type,
            'status' => $this->status,
            'confirmation_date' => $this->confirmation_date,
            'confirmation_num' => $this->confirmation_num,
            'supplier_id' => $this->supplier_id,
            'city_id' => $this->city_id,
            'country_id' => $this->country_id,
            'customer_note' => $this->customer_note,
            'hotel_note' => $this->hotel_note,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'reservation_num' => $this->reservation_num,
            'reservation_link' => $this->reservation_link,
            'count_rooms' => $this->count_rooms,
            'min_check_in' => $this->rooms_min_check_in ?? null,
            'max_check_out' => $this->rooms_max_check_out ?? null,
            'profile' => $this->whenLoaded('profile', function () {
                return new \App\Http\Resources\Profile\ProfileResource($this->profile);
            }),
            'accommodation' => $this->whenLoaded('accommodation', function () {
                return new \App\Http\Resources\AccommodationsResource($this->accommodation);
            }),
        ];
    }
}
