<?php

namespace App\Http\Resources\Profile;

use App\sys\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class AccommodationReservationRoomResource extends JsonResource
{
    protected bool $includeChanges = false;

    public function includeChanges(): self
    {
        $this->includeChanges = true;

        return $this;
    }

    protected function getColumnDisplayMapping()
    {
        return [
            'meal_plan_id' => 'meal_plan',
            'room_type_id' => 'room_type',
            'room_view_id' => 'room_view',
            'currency_id' => 'currency',
            'tax_rate_id' => 'tax_rate',
            'is_active' => 'active',
        ];
    }

    protected function transformChanges(array $changes)
    {
        $mapping = $this->getColumnDisplayMapping();
        $transformedChanges = [];

        foreach ($changes as $columnName) {
            $displayName = $mapping[$columnName] ?? $columnName;
            $transformedChanges[$displayName] = $columnName;
        }

        return $transformedChanges;
    }

    public function toArray($request)
    {
        $taxes = $this->whenLoaded('taxRate', function () {
            return $this->taxRate->map(function ($row) {
                return [
                    'id' => $row->id,
                    'tax_rate_id' => $row->tax_rate_id,
                    'tax_amount' => (float) $row->tax_amount,
                    'tax_rate_amount' => (float) $row->tax_rate_amount,
                    'currency_id' => $row->currency_id,
                    'title' => optional($row->tax)->title,
                ];
            });
        }, function () {
            // Fallback: load directly if relation not eager-loaded
            $collection = $this->taxRate()->with('tax')->get();

            return $collection->map(function ($row) {
                return [
                    'id' => $row->id,
                    'tax_rate_id' => $row->tax_rate_id,
                    'tax_amount' => (float) $row->tax_amount,
                    'tax_rate_amount' => (float) $row->tax_rate_amount,
                    'currency_id' => $row->currency_id,
                    'title' => optional($row->tax)->title,
                ];
            });
        });

        $tax_total = collect($taxes)->sum(function ($t) {
            return (float) ($t['tax_amount'] ?? 0);
        });

        $total_with_tax = (float) $this->total_amount + (float) $tax_total;
        $currency_name = $this->whenLoaded('currency', function () {
            return optional($this->currency)->name;
        }, function () {
            $c = $this->currency()->first();

            return optional($c)->name;
        });

        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id,
            'nationality_id' => $this->nationality_id,
            'nationality_name' => optional($this->whenLoaded('nationality', function () {
                return $this->nationality;
            }, function () {
                return $this->nationality()->first();
            }))->name,
            'reservation_id' => $this->reservation_id,
            'check_in' => $this->check_in,
            'check_out' => $this->check_out,
            'nights_count' => $this->nights_count,
            'adult_count' => $this->adult_count,
            'childreen_count' => $this->childreen_count,
            'no_fee_children_count' => $this->no_fee_children_count,
            'room_number' => $this->room_number,
            'booking_date' => $this->booking_date,
            'meal_plan_id' => $this->meal_plan_id,
            'bed_type' => $this->bed_type,
            'room_type_id' => $this->room_type_id,
            'room_view_id' => $this->room_view_id,
            'extra_bed' => $this->extra_bed,
            'currency_id' => $this->currency_id,
            'currency_name' => $currency_name,
            'total_amount' => $this->total_amount,
            'child_price' => $this->child_price,
            'adult_price' => $this->adult_price,
            'extra_bed_price' => $this->extra_bed_price,
            'commission' => $this->commission,
            'discount' => $this->discount,
            'discount_type' => $this->discount_type,
            //  'tax_rate_id' => $this->tax_rate_id,
            'tax_rate_price' => $this->tax_rate_price,
            'per_night_price' => $this->per_night_price,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'reservation_date' => $this->reservation_date,
            'taxes' => $taxes,
            'taxes_total' => (float) $tax_total,
            'total_with_tax' => (float) $total_with_tax,
            ...($this->includeChanges ? [
                'changes' => $this->transformChanges(Helper::getChangedColumns($this->resource)->toArray()),
            ] : []),
        ];
    }
}
