<?php

namespace App\Http\Resources\User;

// --- هذه إضافات جديدة بناءً على الكود المرسل ---
use App\Http\Resources\AccommodationsResource;
use App\Http\Resources\CompanyResource;
use App\Http\Resources\Roles_Groups\RolesResource;
// --- نهاية الإضافات ---

use App\Http\Resources\ServiceResource;
use Illuminate\Http\Resources\Json\JsonResource; // استدعاء الريسورس بتاع الرول

// استدعاء الريسورس الجديد

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'is_active' => (bool) $this->is_active,
            'employee_number' => $this->employee_number,
            'is_supplier' => (bool) $this->is_supplier,
            'created_at' => $this->created_at,

            // 1. الرول (BelongsTo - تحتاج فحص)
            'role' => $this->whenLoaded('role', function () {
                // فقط قم بإنشاء الريسورس لو العلاقة موجودة (ليست null)
                return $this->role ? new RolesResource($this->role) : null;
            }),

            // 2. الجروبات (ManyToMany - آمنة)
            'groups' => $this->whenLoaded('groups', function () {
                return $this->groups->pluck('id');
            }),
            'group_display' => $this->whenLoaded('groups', function () {
                return $this->groups->map(function ($group) {
                    return [
                        'group_id' => $group->id,
                        'group_name' => $group->name,
                    ];
                });
            }),

            // 3. الخدمات (ManyToMany - آمنة)
            'services' => ServiceResource::collection($this->whenLoaded('services')),

            // 4. الفنادق (ManyToMany - آمنة)
            'accommodations' => AccommodationsResource::collection($this->whenLoaded('accommodations')),

            // 5. الشركات (ManyToMany - آمنة)
            'companies' => CompanyResource::collection($this->whenLoaded('companies')),

            // 6. الحسابات (OneToMany - آمنة)
            'accounting' => UserAccountMappingResource::collection($this->whenLoaded('account_mappings')),

            // 7. التجاوزات (ManyToMany - آمنة)
            'overrides' => $this->whenLoaded('overrides', function () {
                return $this->overrides->map(function ($permission) {
                    return [
                        'id' => $permission->id,
                        'permission_name' => $permission->permission_name,
                        'controller_name' => $permission->Controller_name,
                        'collection_name' => $permission->collection_name,
                        'override_type' => $permission->pivot->override_type,
                        'function_name' => $permission->pivot->function_name,
                    ];
                });
            }),
        ];
    }
}
