<?php

namespace App\Models\Accommodation;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RoomTypes extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'ac_room_types';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    public function translations()
    {
        return $this->hasMany(RoomTypeTranslation::class, 'room_type_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(RoomTypeTranslation::class, 'room_type_id')
            ->where('lang_id', app('lang_id'));
    }
}
