<?php

namespace App\Observers;

use App\Models\Profile\Profile;
use App\sys\Enums\GroupEnum;
use App\sys\Services\Notification\NotificationService;

class ProfileObserver
{
    protected NotificationService $notificationService;

    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }

    /**
     * Handle the Profile "created" event.
     */
    public function created(Profile $profile): void
    {
        // إرسال إشعار لجميع الـ Admins عند إنشاء Profile جديد
        $this->notificationService->sendToGroup(
            groupId: GroupEnum::ADMIN->value,
            type: 'user_action',
            title: 'تم إنشاء Profile جديد',
            message: "تم إنشاء Profile رقم {$profile->profile_number} بنجاح",
            modelName: 'Profile',
            modelId: $profile->id,
            data: [
                'profile_number' => $profile->profile_number,
                'customer_id' => $profile->customer_id,
                'user_id' => $profile->user_id,
                'action' => 'created',
            ]
        );
    }

    /**
     * Handle the Profile "updated" event.
     */
    public function updated(Profile $profile): void
    {
        // إرسال إشعار لجميع الـ Admins عند تحديث Profile
        $this->notificationService->sendToGroup(
            groupId: GroupEnum::ADMIN->value,
            type: 'user_action',
            title: 'تم تحديث Profile',
            message: "تم تحديث Profile رقم {$profile->profile_number}",
            modelName: 'Profile',
            modelId: $profile->id,
            data: [
                'profile_number' => $profile->profile_number,
                'action' => 'updated',
            ]
        );
    }

    /**
     * Handle the Profile "deleted" event.
     */
    public function deleted(Profile $profile): void
    {
        // إرسال إشعار لجميع الـ Admins عند حذف Profile
        $this->notificationService->sendToGroup(
            groupId: GroupEnum::ADMIN->value,
            type: 'user_action',
            title: 'تم حذف Profile',
            message: "تم حذف Profile رقم {$profile->profile_number}",
            modelName: 'Profile',
            modelId: $profile->id,
            data: [
                'profile_number' => $profile->profile_number,
                'action' => 'deleted',
            ]
        );
    }

    /**
     * Handle the Profile "restored" event.
     */
    public function restored(Profile $profile): void
    {
        // إرسال إشعار لجميع الـ Admins عند استعادة Profile
        $this->notificationService->sendToGroup(
            groupId: GroupEnum::ADMIN->value,
            type: 'user_action',
            title: 'تم استعادة Profile',
            message: "تم استعادة Profile رقم {$profile->profile_number}",
            modelName: 'Profile',
            modelId: $profile->id,
            data: [
                'profile_number' => $profile->profile_number,
                'action' => 'restored',
            ]
        );
    }

    /**
     * Handle the Profile "force deleted" event.
     */
    public function forceDeleted(Profile $profile): void
    {
        // إرسال إشعار لجميع الـ Admins عند الحذف النهائي لـ Profile
        $this->notificationService->sendToGroup(
            groupId: GroupEnum::ADMIN->value,
            type: 'user_action',
            title: 'تم الحذف النهائي لـ Profile',
            message: "تم الحذف النهائي لـ Profile رقم {$profile->profile_number}",
            modelName: 'Profile',
            modelId: $profile->id,
            data: [
                'profile_number' => $profile->profile_number,
                'action' => 'force_deleted',
            ]
        );
    }
}
