<?php

namespace App\Providers;

use App\Models\Accounting\Constraint;
use App\Models\General\Area;
use App\Models\General\Category;
use App\Models\General\City;
use App\Models\General\Companies;
use App\Models\General\CompanyAccountMappings;
use App\Models\General\Country;
use App\Models\General\Currency;
use App\Models\General\Domain;
use App\Models\General\GuideLanguage;
use App\Models\General\Nationality;
use App\Models\General\OperationData;
use App\Models\General\Restaurant;
use App\Models\General\Service;
use App\Models\General\TaxRate;
use App\Models\General\TaxRateMappings;
use App\Models\General\TransportationModes;
use App\Models\General\TransportationReason;
use App\Models\General\WorkPeriod;
use App\Models\invoice\InvoiceServices;
use App\Models\Profile\AccommodationReservation;
use App\Models\Profile\AccommodationReservationRoom;
use App\Models\Profile\Customer;
use App\Models\Profile\Profile;
use App\Models\Profile\ProfileTraveler;
use App\Models\Role;
use App\Models\User;
use App\Models\UserAccountMapping;
use App\Observers\InvoiceServicesObserver;
use App\Observers\ProfileObserver;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Relation::enforceMorphMap([
            'Profile' => Profile::class,
            'ProfileTraveler' => ProfileTraveler::class,
            'Nationality' => Nationality::class,
            'Currency' => Currency::class,
            'Country' => Country::class,
            'City' => City::class,
            'Area' => Area::class,
            'Category' => Category::class,
            'TaxRate' => TaxRate::class,
            'Domain' => Domain::class,
            'Company' => Companies::class,
            'Customer' => Customer::class,
            'Service' => Service::class,
            'CompanyAccountMappings' => CompanyAccountMappings::class,
            'TaxRateMappings' => TaxRateMappings::class,
            'Restaurant' => Restaurant::class,
            'WorkPeriod' => WorkPeriod::class,
            'OperationData' => OperationData::class,
            'TransportationModes' => TransportationModes::class,
            'TransportationReason' => TransportationReason::class,
            'AccommodationReservation' => AccommodationReservation::class,
            'AccommodationReservationRoom' => AccommodationReservationRoom::class,
            'guideLanguages' => GuideLanguage::class,
            'constraint' => Constraint::class,
            'InvoiceServices' => InvoiceServices::class,
            'user' => User::class,
            'role' => Role::class,
            'user_account_mapping' => UserAccountMapping::class,
            'Invoice' => \App\Models\Accounting\Invoice::class,
        ]);

        // Register Observers
        Profile::observe(ProfileObserver::class);
        InvoiceServices::observe(InvoiceServicesObserver::class);

        Gate::define('viewPulse', function ($user = null) {
            return true;
        });

        Livewire::setUpdateRoute(function ($handle) {
            return Route::post('/public/livewire/update', $handle);
        });

        // وهذا أيضاً لملف الجافاسكريبت لضمان تحميله من المسار الصحيح
        Livewire::setScriptRoute(function ($handle) {
            return Route::get('/public/livewire/livewire.js', $handle);
        });
    }
}
