<?php

namespace App\sys\Repository\General;

use App\Models\General\OperationDataTranslation;

class OperationDataTranslationRepository
{
    private $operationDataTranslation;

    public function __construct()
    {
        $this->operationDataTranslation = new OperationDataTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new OperationDataTranslation;
        $rt->operation_data_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->operationDataTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->operationDataTranslation->with('getLang')->where('operation_data_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->operationDataTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
