<?php

namespace App\sys\Repository\General;

use App\Models\General\ServicesTranslation;

class ServiceTranslationRepository
{
    private $serviceTranslation;

    public function __construct()
    {
        $this->serviceTranslation = new ServicesTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new ServicesTranslation;
        $rt->services_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->title = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->serviceTranslation->find($data['id']);
        $rt->title = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->serviceTranslation->with('getLang')->where('services_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->serviceTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
