<?php

namespace App\sys\Repository\General;

use App\Models\General\WorkPeriodTranslation;

class WorkPeriodTranslationRepository
{
    private $workPeriodTranslation;

    public function __construct()
    {
        $this->workPeriodTranslation = new WorkPeriodTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new WorkPeriodTranslation;
        $rt->work_period_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->period = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->workPeriodTranslation->find($data['id']);
        $rt->period = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->workPeriodTranslation->with('getLang')->where('work_period_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->workPeriodTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
