<?php

namespace App\sys\Repository\Profile;

use App\Models\Accommodation\MealPlans;
use App\Models\Accommodation\RoomTypes;
use App\Models\Accommodation\RoomViews;
use App\Models\General\Currency;
use App\Models\Profile\AccommodationReservationRoom;
use App\Models\User;

class AccommodationReservationRoomRepository
{
    public function getAll()
    {
        return AccommodationReservationRoom::all();
    }

    public function findByIdOrFail(int $id)
    {
        return AccommodationReservationRoom::with('taxRate', 'currency', 'nationality')->find($id);
    }

    public function getAllByReservationId(int $id)
    {
        return AccommodationReservationRoom::where('reservation_id', $id)->get();
    }

    public function create(array $data)
    {
        $item = new AccommodationReservationRoom;
        $item->profile_id = $data['profile_id'];
        $item->nationality_id = $data['nationality_id'] ?? null;
        $item->reservation_id = $data['reservation_id'];
        $item->check_in = $data['check_in'];
        $item->check_out = $data['check_out'];
        $item->nights_count = $data['nights_count'];
        $item->adult_count = $data['adult_count'];
        $item->childreen_count = $data['childreen_count'];
        $item->no_fee_children_count = $data['no_fee_children_count'] ?? 0;
        $item->room_number = $data['room_number'] ?? null;
        $item->booking_date = $data['booking_date'] ?? null;
        $item->meal_plan_id = $data['meal_plan_id'] ?? null;
        $item->bed_type = $data['bed_type'] ?? null;
        $item->room_type_id = $data['room_type_id'] ?? null;
        $item->room_view_id = $data['room_view_id'] ?? null;
        $item->extra_bed = $data['extra_bed'] ?? 0;
        $item->currency_id = $data['currency_id'];
        $item->adult_price = $data['adult_price'] ?? 0;
        $item->child_price = $data['child_price'] ?? 0;
        $item->extra_bed_price = $data['extra_bed_price'] ?? 0;
        $item->commission = $data['commission'] ?? 0;
        $item->discount = $data['discount'] ?? 0;
        $item->discount_type = $data['discount_type'] ?? 'value';
        $item->tax_rate_price = 0;
        $item->per_night_price = $data['per_night_price'];
        $item->total_amount = $data['total_amount'];
        $item->reservation_date = $data['reservation_date'] ?? null;
        $item->save();

        return $item;
    }

    public function update(AccommodationReservationRoom $item, array $data)
    {
        $item->profile_id = $data['profile_id'] ?? $item->profile_id;
        $item->nationality_id = array_key_exists('nationality_id', $data) ? $data['nationality_id'] : $item->nationality_id;
        $item->reservation_id = $data['reservation_id'] ?? $item->reservation_id;
        $item->check_in = $data['check_in'] ?? $item->check_in;
        $item->check_out = $data['check_out'] ?? $item->check_out;
        $item->nights_count = $data['nights_count'] ?? $item->nights_count;
        $item->adult_count = $data['adult_count'] ?? $item->adult_count;
        $item->childreen_count = $data['childreen_count'] ?? $item->childreen_count;
        $item->no_fee_children_count = $data['no_fee_children_count'] ?? $item->no_fee_children_count;
        $item->room_number = $data['room_number'] ?? $item->room_number;
        $item->booking_date = $data['booking_date'] ?? $item->booking_date;
        $item->meal_plan_id = $data['meal_plan_id'] ?? $item->meal_plan_id;
        $item->bed_type = $data['bed_type'] ?? $item->bed_type;
        $item->room_type_id = $data['room_type_id'] ?? $item->room_type_id;
        $item->room_view_id = $data['room_view_id'] ?? $item->room_view_id;
        $item->extra_bed = $data['extra_bed'] ?? $item->extra_bed;
        $item->currency_id = $data['currency_id'] ?? $item->currency_id;
        $item->adult_price = $data['adult_price'] ?? $item->adult_price;
        $item->child_price = $data['child_price'] ?? $item->child_price;
        $item->extra_bed_price = $data['extra_bed_price'] ?? $item->extra_bed_price;
        $item->commission = $data['commission'] ?? $item->commission;
        $item->discount = $data['discount'] ?? $item->discount;
        $item->discount_type = array_key_exists('discount_type', $data) ? $data['discount_type'] : $item->discount_type;
        $item->tax_rate_price = $data['tax_rate_price'] ?? $item->tax_rate_price;
        $item->per_night_price = $data['per_night_price'] ?? $item->per_night_price;
        $item->total_amount = $data['total_amount'] ?? $item->total_amount;
        $item->reservation_date = $data['reservation_date'] ?? null;
        $item->save();

        return $item;
    }

    public function del(array $ids)
    {
        return AccommodationReservationRoom::whereIn('id', $ids)->get();
    }

    public function deleteByIds(array $ids)
    {
        return AccommodationReservationRoom::whereIn('id', $ids)->delete();
    }

    public function getTotalsByReservationProfile(int $reservationId, int $profileId, ?int $excludeId = null)
    {
        $query = AccommodationReservationRoom::where('reservation_id', $reservationId)
            ->where('profile_id', $profileId);
        if (! is_null($excludeId)) {
            $query->where('id', '!=', $excludeId);
        }

        return $query->selectRaw('COALESCE(SUM(adult_count),0) as adults')
            ->selectRaw('COALESCE(SUM(childreen_count),0) as children')
            ->selectRaw('COALESCE(SUM(no_fee_children_count),0) as no_fee_children')
            ->first();
    }

    public function getTotalsByReservationProfileNationality(int $reservationId, int $profileId, int $nationalityId, ?int $excludeId = null)
    {
        $query = AccommodationReservationRoom::where('reservation_id', $reservationId)
            ->where('profile_id', $profileId)
            ->where('nationality_id', $nationalityId);
        if (! is_null($excludeId)) {
            $query->where('id', '!=', $excludeId);
        }

        return $query->selectRaw('COALESCE(SUM(adult_count),0) as adults')
            ->selectRaw('COALESCE(SUM(childreen_count),0) as children')
            ->first();
    }

    public function getColumnChanges($room, $columnName)
    {
        return $room->audits()
            ->get()
            ->filter(function ($audit) use ($columnName) {
                $oldValues = $audit->old_values ?? [];
                $newValues = $audit->new_values ?? [];

                return array_key_exists($columnName, $oldValues) ||
                    array_key_exists($columnName, $newValues);
            })
            ->map(function ($audit) use ($columnName) {
                $user = null;
                if ($audit->user_id) {
                    $userModel = User::find($audit->user_id);
                    $user = $userModel ? $userModel->toArray() : null;
                }

                $oldValues = $audit->old_values ?? [];
                $newValues = $audit->new_values ?? [];

                if (in_array($columnName, ['meal_plan_id', 'room_type_id', 'room_view_id', 'currency_id'])) {
                    $oldId = $oldValues[$columnName] ?? null;
                    $newId = $newValues[$columnName] ?? null;

                    $ids = array_filter([$oldId, $newId]);

                    if (! empty($ids)) {
                        switch ($columnName) {
                            case 'meal_plan_id':
                                $models = MealPlans::whereIn('id', $ids)->pluck('name', 'id');
                                break;
                            case 'room_type_id':
                                $models = RoomTypes::whereIn('id', $ids)->pluck('name', 'id');
                                break;
                            case 'room_view_id':
                                $models = RoomViews::whereIn('id', $ids)->pluck('name', 'id');
                                break;
                            case 'currency_id':
                                $models = Currency::whereIn('id', $ids)->pluck('name', 'id');
                                break;
                        }
                        $oldValue = $oldId ? ($models[$oldId] ?? null) : null;
                        $newValue = $newId ? ($models[$newId] ?? null) : null;
                    }
                } else {
                    $oldValue = $oldValues[$columnName] ?? null;
                    $newValue = $newValues[$columnName] ?? null;
                }

                return [
                    'audit_id' => $audit->id,
                    'user_id' => $audit->user_id ?? null,
                    'user' => $user['name'] ?? null,
                    'old_value' => $oldValue,
                    'new_value' => $newValue,
                    'changed_at' => $audit->created_at,
                    'event' => $audit->event,
                    'ip_address' => $audit->ip_address,
                    'user_agent' => $audit->user_agent,
                ];
            })
            ->values();
    }
}
