<?php

namespace App\sys\Services\Accommodation;

use App\sys\Repository\Accommodation\RoomTypesRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class RoomTypesServices extends Services
{
    private $roomTypes;

    public function __construct()
    {
        $this->roomTypes = new RoomTypesRepository;
    }

    public function add($data)
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'occupancy' => ['nullable ', 'integer', 'min:1', 'max:100'],
            'active' => ['required', 'in:0,1'],
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        $roomType = $this->roomTypes->add($data);
        $this->syncTranslations($roomType);

        return $roomType;
    }

    public function update($data)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_types,id'],
            'name' => ['sometimes', 'string', 'max:255'],
            'occupancy' => ['sometimes', 'nullable ', 'integer', 'min:1', 'max:100'],
            'active' => ['sometimes', 'in:0,1'],
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->roomTypes->updated($data);
    }

    public function get()
    {
        return $this->roomTypes->get();
    }

    public function getByid($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_types,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError('Not Found');

            return false;
        }

        return $this->roomTypes->getById($id);
    }

    public function getActive()
    {
        return $this->roomTypes->getActive();
    }

    public function getByIdWithTranslation($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_types,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $roomType = $this->roomTypes->getByIdWithTranslation($id);

        return $this->syncTranslations($roomType, true);
    }

    public function del(array $ids)
    {
        return $this->roomTypes->del($ids);
    }

    public function getAllChanges($roomType)
    {
        return $this->roomTypes->getAllChanges($roomType);
    }
}
