<?php

namespace App\Http\Controllers\Accommodation;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accommodation\MealPlanHistoryResource;
use App\Http\Resources\MealPlansCollection;
use App\Http\Resources\MealPlansResource;
use App\sys\ApiResponse;
use App\sys\Services\Accommodation\MealPlansServices;
use App\sys\Services\Accommodation\MealPlanTranslationServices;
use Illuminate\Http\Request;

class MealPlanesController extends Controller
{
    use ApiResponse;

    private $mealPlanes;

    private $mealPlansTranslations;

    public function __construct()
    {
        $this->mealPlanes = new MealPlansServices;
        $this->mealPlansTranslations = new MealPlanTranslationServices;
    }

    public function create(Request $request)
    {
        if ($meal = $this->mealPlanes->add($request->all())) {
            $collect = new MealPlansResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->mealPlanes->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function update(Request $request)
    {
        if ($meal = $this->mealPlanes->update($request->all())) {
            $collect = new MealPlansResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->mealPlanes->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function index()
    {
        $data = $this->mealPlanes->get();
        $collect = new MealPlansCollection($data);

        return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
    }

    public function getActive()
    {
        $data = $this->mealPlanes->getActive();
        $collect = new MealPlansCollection($data);

        return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
    }

    public function getByid($id = 0)
    {
        if ($data = $this->mealPlanes->getById($id)) {
            $collect = new MealPlansResource($data);

            return $this->apiResponse(200, 'Meal Plan retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Meal Plan not found', ['Meal Plan not found'], null);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->mealPlanes->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Meal Plans deleted successfully', null, null);
        }
        $errors = $this->mealPlanes->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->mealPlansTranslations->save($request->all(), $id)) {
            $errors = $this->mealPlansTranslations->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->mealPlanes->getByidWithTranslation($id)) {
            $collection = new \App\Http\Resources\Accommodation\MealPlan\MealPlanLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->mealPlanes->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->mealPlansTranslations->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->mealPlansTranslations->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $mealPlan = $this->mealPlanes->getById($id);
        if (! $mealPlan) {
            $errors = $this->mealPlanes->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        $changes = $this->mealPlanes->getAllChanges($mealPlan);

        return $this->apiResponse(200, 'success', null, MealPlanHistoryResource::collection($changes));
    }
}
