<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\SettingsResource;
use App\sys\ApiResponse;
use App\sys\Services\General\SettingsService;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    use ApiResponse;

    protected SettingsService $settingsService;

    public function __construct(SettingsService $settingsService)
    {
        $this->settingsService = $settingsService;
    }

    /**
     * عرض جميع الإعدادات
     */
    public function index()
    {
        $settings = $this->settingsService->getAllSettings();

        return $this->apiResponse(200, 'success', null, SettingsResource::collection($settings));
    }

    /**
     * عرض إعداد محدد
     */
    public function show(string $key)
    {
        $setting = $this->settingsService->getSetting($key);

        if (! $setting) {
            return $this->apiResponse(400, 'fail', ['الإعداد المطلوب غير موجود'], null);
        }

        return $this->apiResponse(200, 'success', null, new SettingsResource($setting));
    }

    /**
     * تحديث إعداد محدد
     */
    public function update(Request $request)
    {
        if ($setting = $this->settingsService->updateSetting($request->all())) {
            return $this->apiResponse(200, 'success', null, SettingsResource::collection($setting));
        }

        $errors = $this->settingsService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }
}
