<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AccommodationsResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'description' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->description ?? $this->description)
                : $this->description,
            'type' => $this->type,
            'rating_id' => $this->rating_id,
            'country_id' => $this->country_id,
            'city_id' => $this->city_id,
            'active' => $this->is_active,
            'address' => $this->address,
            'phone' => $this->phone,
            'email' => $this->email,
            'website' => $this->website,
            'taxable' => (bool) $this->taxable,
            'is_main_provider' => (bool) $this->is_main_provider,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'country' => $this->relationLoaded('country') && $this->country ? [
                'id' => $this->country->id,
                'name' => $this->country->relationLoaded('currentTranslation')
                    ? ($this->country->currentTranslation->name ?? $this->country->name)
                    : $this->country->name,
            ] : null,
            'city' => $this->relationLoaded('city') && $this->city ? [
                'id' => $this->city->id,
                'name' => $this->city->relationLoaded('currentTranslation')
                    ? ($this->city->currentTranslation->name ?? $this->city->name)
                    : $this->city->name,
            ] : null,
            'rating' => $this->relationLoaded('rating') && $this->rating ? [
                'id' => $this->rating->id,
                'name' => $this->rating->relationLoaded('currentTranslation') && $this->rating->currentTranslation
                    ? $this->rating->currentTranslation->name
                    : $this->rating->name,
            ] : null,
            'suppliers' => $this->whenLoaded('suppliers', function () {
                return $this->suppliers->map(function ($supplier) {
                    return [
                        'id' => $supplier->id,
                        'name' => $supplier->relationLoaded('currentTranslation') && $supplier->currentTranslation
                            ? $supplier->currentTranslation->supplier_name
                            : $supplier->supplier_name,
                        'vat' => $supplier->supplier_vat,
                        'active' => $supplier->supplier_active,
                    ];
                });
            }),
        ];
    }
}
