<?php

namespace App\Http\Resources\General\Company;

use Illuminate\Http\Resources\Json\JsonResource;

class CompanyLangResources extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name_company,
            'default_invoice_footer' => $this->default_invoice_footer,
            'companie_address' => $this->companie_address_1,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? CompanyTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
