<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class DailyProgramsResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id,
            'day_number' => $this->day_number,
            'day_date' => $this->day_date,
            'services_count' => $this->when(isset($this->invoice_services_count), (int) $this->invoice_services_count),
            'has_services' => $this->when(isset($this->invoice_services_count), (bool) ($this->invoice_services_count > 0)),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
