<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class TravelerResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id,
            'nationality_id' => $this->nationality_id,
            'currency_id' => $this->currency_id,
            'type' => $this->type,
            'unit_price' => $this->unit_price,
            'count' => $this->count,
            'total_price' => $this->total_price,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'nationality' => $this->when($this->relationLoaded('nationality'), function () {
                return $this->nationality ? [
                    'id' => $this->nationality->id,
                    'name' => $this->nationality->relationLoaded('currentTranslation')
                        ? ($this->nationality->currentTranslation->name ?? $this->nationality->name)
                        : $this->nationality->name,
                ] : null;
            }),
            'currency' => $this->when($this->relationLoaded('currency'), function () {
                return $this->currency ? [
                    'id' => $this->currency->id,
                    'name' => $this->currency->relationLoaded('currentTranslation')
                        ? ($this->currency->currentTranslation->name ?? $this->currency->name)
                        : $this->currency->name,
                    'code' => $this->currency->code,
                ] : null;
            }),
            'profile' => $this->when($this->relationLoaded('profile'), function () {
                return $this->profile ? [
                    'id' => $this->profile->id,
                    'profile_number' => $this->profile->profile_number,
                ] : null;
            }),
        ];
    }
}
