<?php

namespace App\Http\Resources\Suppliers;

use Illuminate\Http\Resources\Json\JsonResource;

class SupplierLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'supplier_name' => $this->supplier_name,
            'supplier_address' => $this->supplier_address,
            'active' => $this->supplier_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? SupplierTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
