<?php

namespace App\Models\Suppliers;

use App\Models\Accommodation\Accommodations;
use App\Models\General\Category;
use App\Models\General\Domain;
use App\Models\General\Service;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Suppliers extends Model
{
    use SoftDeletes;

    protected $table = 'su_supplier';

    const UPDATED_AT = 'modified';

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'suppliers_categories', 'supplier_id', 'category_id');
    }

    public function services()
    {
        return $this->belongsToMany(Service::class, 'suppliers_services', 'supplier_id', 'service_id');
    }

    public function accommodations()
    {
        return $this->belongsToMany(Accommodations::class, 'supplier_accommodation', 'supplier_id', 'accommodation_id');
    }

    public function domains()
    {
        return $this->belongsToMany(Domain::class, 'supplier_domain', 'supplier_id', 'domain_id');
    }

    public function accounting()
    {
        return $this->hasMany(SupplierAccountMappings::class, 'supplier_id')->with('currency', 'tree');
    }

    public function translations()
    {
        return $this->hasMany(SupplierTranslation::class, 'supplier_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(SupplierTranslation::class, 'supplier_id')
            ->where('lang_id', app('lang_id'));
    }
}
