<?php

namespace App\Rules;

use App\Models\General\Currency;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class MatchCurrenciesCount implements ValidationRule
{
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $currenciesCount = Currency::where('status', 1)
            ->whereNull('deleted_at')->count();

        if (count($value) !== $currenciesCount) {
            $fail("The {$attribute} must contain exactly {$currenciesCount} objects, one for each currency.");
        }
    }
}
