<?php

namespace App\sys\Repository\General;

use App\Models\General\RestaurantTranslation;

class RestaurantTranslationRepository
{
    private $restaurantTranslation;

    public function __construct()
    {
        $this->restaurantTranslation = new RestaurantTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new RestaurantTranslation;
        $rt->restaurant_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->restaurantTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->restaurantTranslation->with('getLang')->where('restaurant_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->restaurantTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
