<?php

namespace App\sys\Services\Accounting;

use App\sys\Repository\Accounting\ReportRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class ReportService extends Services
{
    protected ReportRepository $reportRepository;

    public function __construct(ReportRepository $reportRepository)
    {
        $this->reportRepository = $reportRepository;
    }

    public function getReports()
    {
        return $this->reportRepository->getReports();
    }

    public function getHierarchicalTreeAccountReport()
    {
        $validator = Validator::make(request()->all(), [
            'currency_id' => ['sometimes', 'integer', 'exists:currencies,id'],
            'date_from' => ['sometimes', 'date'],
            'date_to' => ['sometimes', 'date'],
            'type' => ['required', 'in:balance,income'],
        ]);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->reportRepository->getHierarchicalTreeAccountReport();
    }

    public function getHierarchicalTreeAccountTrailBalance()
    {
        $validator = Validator::make(request()->all(), [
            'currency_id' => ['sometimes', 'integer', 'exists:currencies,id'],
            'date_from' => ['required', 'date'],
            'date_to' => ['required', 'date'],
        ]);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->reportRepository->getHierarchicalTreeAccountReportTrailBalance();
    }

    public function treeAccountTransfers(array $request)
    {

        $validator = Validator::make($request, [
            'treeAccount_ids' => ['required', 'array', 'min:1'],
            'treeAccount_ids.*' => ['required', 'integer', 'exists:tree_accounting,id'],
            'show_by_default' => ['required', 'boolean'],
            'date_from' => ['nullable', 'date', 'date_format:Y-m-d'],
            'date_to' => ['nullable', 'date', 'date_format:Y-m-d', 'after_or_equal:date_from'],
            'company_ids' => ['nullable', 'array'],
            'company_ids.*' => ['integer', 'exists:companies,id'],
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->reportRepository->treeAccountTransfer($request);
    }

    public function treeAccountTransfersWithInitialBalance(array $request)
    {
        $validator = Validator::make($request, [
            'treeAccount_ids' => ['required', 'array', 'min:1'],
            'treeAccount_ids.*' => ['required', 'exists:tree_accounting,id'],
            'show_by_default' => ['required', 'boolean'],
            'date_from' => ['nullable', 'date', 'date_format:Y-m-d'],
            'date_to' => ['nullable', 'date', 'date_format:Y-m-d', 'after_or_equal:date_from'],
            'company_ids' => ['nullable', 'array'],
            'company_ids.*' => ['nullable', 'exists:companies,id'],
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->reportRepository->treeAccountTransferWithInitialBalance($request);
    }

    public function costCenterReport(array $request)
    {
        $validator = Validator::make($request, [
            'cost_center_ids' => ['required', 'array', 'min:1'],
            'cost_center_ids.*' => ['required', 'integer', 'exists:tree_accounting,id'],
            'date_from' => ['nullable', 'date', 'date_format:Y-m-d'],
            'date_to' => ['nullable', 'date', 'date_format:Y-m-d', 'after_or_equal:date_from'],
            'company_ids' => ['nullable', 'array'],
            'company_ids.*' => ['integer', 'exists:companies,id'],
            'active' => ['required', 'boolean'],
        ]);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->reportRepository->costCenterReport($request);
    }
}
