* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'DejaVu Sans', sans-serif;
    background-color: #f5f5f5;
    padding: 20px;
}

.pdf-body {
    max-width: 1600px;
    margin: 0 auto;
    background: white;
    padding: 20px;
}

.account-section {
    margin-bottom: 40px;
    page-break-inside: avoid;
    border: 1px solid #dee2e6;
    overflow: hidden;
}

.account-header {
    background: #fbfbfbff !important;
    padding: 15px 20px;
    color: #212529 !important;
    border-bottom: 3px solid #ffffffff;
}

.account-title {
    font-size: 18px;
    font-weight: bold;
    margin: 0 0 5px 0;
    display: block;
}

.account-serial {
    font-size: 13px;
    display: block;
    color: #495057;
}

.account-table {
    width: 100%;
    border-collapse: collapse;
    background: white;
}

.account-table thead {
    background-color: #e9ecef;
}

.account-table th {
    padding: 12px 10px;
    text-align: center;
    font-size: 13px;
    font-weight: 600;
    color: #495057;
    border: 1px solid #dee2e6;
}

.account-table tbody tr {
    background-color: #ffffff;
}

.account-table tbody tr:nth-child(even) {
    background-color: #f8f9fa;
}

.account-table td {
    padding: 10px 8px;
    text-align: center;
    font-size: 12px;
    border: 1px solid #dee2e6;
}

.account-table tfoot {
    background-color: #f7a244 !important;
    font-weight: bold;
}

.account-table tfoot td {
    padding: 12px 10px;
    border: 1px solid #dee2e6;
    color: #212529 !important;
}

.text-right {
    text-align: right !important;
}

.debit {
    color: #dc3545;
    font-weight: 500;
}

.credit {
    color: #28a745;
    font-weight: 500;
}

.negative-value {
    color: #dc3545;
    font-weight: 600;
}

.no-transactions {
    padding: 30px;
    text-align: center;
    background-color: #f8f9fa;
    color: #6c757d;
    font-style: italic;
}

@media print {
    body {
        padding: 0;
    }
    .pdf-body {
        padding: 10px;
    }
    .account-section {
        page-break-inside: avoid;
        margin-bottom: 30px;
    }
}