/* === PDF BODY & TABLE STYLING === */

.pdf-body {
    font-family: "DejaVu Sans", sans-serif;
    text-align: right;
    font-size: 13px;
    color: #222;
    background-color: #fff;
    padding: 15px 25px;
}

/* ===== Cost Center Section ===== */
.cost-center-section {
    margin-bottom: 35px;
    border: 1px solid #ddd;
    border-radius: 6px;
    background-color: #fafafa;
    page-break-inside: avoid;
}

.cost-center-title {
    background: linear-gradient(to left, #0c4b8f, #357abd);
    color: #fff;
    padding: 8px 12px;
    font-weight: bold;
    font-size: 15px;
    border-radius: 6px 6px 0 0;
    margin-bottom: 10px;
}

/* ===== Tables ===== */
.cost-center-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 10px;
    background-color: #fff;
}

.cost-center-table th,
.cost-center-table td {
    border: 1px solid #ccc;
    padding: 8px 10px;
    text-align: center;
    vertical-align: middle;
    font-size: 12px;
}

.cost-center-table thead {
    background-color: #0c4b8f;
    color: #fff;
}

.cost-center-table tbody tr:nth-child(even) {
    background-color: #f5f7fa;
}

.cost-center-table tbody tr:hover {
    background-color: #e8f0ff;
}

/* ===== Totals ===== */
.total-row {
    background-color: #dce6f9;
    font-weight: bold;
}

.total-row td {
    border-top: 2px solid #0c4b8f;
}

/* ===== Debit & Credit Formatting ===== */
.debit {
    color: #e53935; /* Red */
    font-weight: bold;
}
.credit {
    color: #43a047; /* Green */
    font-weight: bold;
}

/* ===== No Data Message ===== */
.no-data {
    text-align: center;
    padding: 15px;
    color: #777;
    background-color: #f9f9f9;
    border: 1px dashed #ccc;
    border-radius: 4px;
    margin-top: 15px;
}

/* ===== Footer (if inside body) ===== */
.pdf-footer {
    text-align: center;
    color: #777;
    font-size: 11px;
    margin-top: 25px;
    border-top: 1px solid #ddd;
    padding-top: 8px;
}
