/* PDF Header Styles */
.pdf-header {
    width: 100%;
    padding: 20px;
    border-bottom: 2px solid #333;
    margin-bottom: 20px;
}

.header-container {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 20px;
    margin-bottom: 15px;
}

.header-left,
.header-center,
.header-right {
    flex: 1;
}

.header-left {
    text-align: left;
}

.header-center {
    text-align: center;
}

.header-center h2 {
    margin: 0;
    font-size: 24px;
    font-weight: bold;
}

.header-right {
    text-align: right;
}

.header-left p,
.header-right p {
    margin: 5px 0;
    font-size: 14px;
}

.header-dates {
    text-align: center;
    margin-top: 10px;
}

.header-dates p {
    margin: 0;
    font-size: 14px;
    font-weight: 500;
}

/* RTL Support */
[dir="rtl"] .header-left {
    text-align: right;
}

[dir="rtl"] .header-right {
    text-align: left;
}

/* LTR Specific (your current case) */
[dir="ltr"] .header-left {
    text-align: left;
}

[dir="ltr"] .header-right {
    text-align: right;
}

/* Extra section for multiple companies */
.header-extra {
    margin-top: 15px;
    border-top: 1px dashed #888;
    padding-top: 10px;
}

.header-extra table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.header-extra th {
    background-color: #f3f3f3;
    border-bottom: 1px solid #ccc;
    text-align: center;
    padding: 5px;
    font-weight: bold;
}

.header-extra td {
    text-align: center;
    border-bottom: 1px solid #eee;
    padding: 4px;
}
