* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'DejaVu Sans', sans-serif;
    background-color: #f5f5f5;
    padding: 20px;
}

.pdf-body {
    max-width: 1600px;
    margin: 0 auto;
    background: white;
    padding: 20px;
}

/* كل قسم حساب منفصل */
.account-section {
    margin-bottom: 40px;
    page-break-inside: avoid;
    border: 1px solid #dee2e6;
    overflow: hidden;
}

/* هيدر الحساب */
.account-header {
    background: #fcfcfcff !important;
    padding: 15px 20px;
    color: #212529 !important;
    border-bottom: 3px solid #fcf2eeff;
}

.account-title {
    font-size: 18px;
    font-weight: bold;
    margin: 0 0 5px 0;
    display: block;
}

.account-serial {
    font-size: 13px;
    display: block;
    color: #495057;
}

/* جدول الملخص */
.summary-table {
    width: 100%;
    border-collapse: collapse;
    background: white;
}

.summary-table thead {
    background-color: #e9ecef;
}

.summary-table th {
    padding: 12px 10px;
    text-align: center;
    font-size: 13px;
    font-weight: 600;
    color: #495057;
    border: 1px solid #dee2e6;
}

.summary-table tbody td {
    padding: 12px 10px;
    text-align: center;
    font-size: 13px;
    border: 1px solid #dee2e6;
    background-color: #f8f9fa;
    font-weight: 600;
}

/* جدول المعاملات */
.transactions-table {
    width: 100%;
    border-collapse: collapse;
    background: white;
    margin-top: 0;
}

.transactions-table thead {
    background-color: #e9ecef;
}

.transactions-table th {
    padding: 12px 10px;
    text-align: center;
    font-size: 13px;
    font-weight: 600;
    color: #495057;
    border: 1px solid #dee2e6;
}

.transactions-table tbody tr {
    background-color: #ffffff;
}

.transactions-table tbody tr:nth-child(even) {
    background-color: #f8f9fa;
}

.transactions-table td {
    padding: 10px 8px;
    text-align: center;
    font-size: 12px;
    border: 1px solid #dee2e6;
}

/* الألوان */
.debit {
    color: #dc3545;
    font-weight: 500;
}

.credit {
    color: #28a745;
    font-weight: 500;
}

.negative-value {
    color: #dc3545;
    font-weight: 600;
}

/* لو مفيش معاملات */
.no-transactions {
    padding: 30px;
    text-align: center;
    background-color: #f8f9fa;
    color: #6c757d;
    font-style: italic;
}

@media print {
    body {
        padding: 0;
    }
    .pdf-body {
        padding: 10px;
    }
    .account-section {
        page-break-inside: avoid;
        margin-bottom: 30px;
    }
}