* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'DejaVu Sans', sans-serif;
    background-color: #f5f5f5;
    padding: 20px;
}

.pdf-body {
    max-width: 1600px;
    margin: 0 auto;
    background: white;
    padding: 20px;
}

/* كل قسم حساب منفصل */
.account-section {
    margin-bottom: 40px;
    page-break-inside: avoid;
    border: 1px solid #dee2e6;
    overflow: hidden;
}

/* هيدر الحساب */
.account-header {
    background: #fafafaff !important;
    padding: 15px 20px;
    color: #212529 !important;
    border-bottom: 3px solid #ebebebff;
}

.account-title {
    font-size: 18px;
    font-weight: bold;
    margin: 0 0 5px 0;
    display: block;
}

.account-serial {
    font-size: 13px;
    display: block;
    color: #495057;
}

/* الجدول */
.account-table {
    width: 100%;
    border-collapse: collapse;
    background: white;
}

.account-table thead {
    background-color: #e9ecef;
}

.account-table th {
    padding: 12px 10px;
    text-align: center;
    font-size: 13px;
    font-weight: 600;
    color: #495057;
    border: 1px solid #dee2e6;
}

.account-table tbody tr {
    background-color: #ffffff;
}

.account-table tbody tr:nth-child(even) {
    background-color: #f8f9fa;
}

.account-table td {
    padding: 10px 8px;
    text-align: center;
    font-size: 12px;
    border: 1px solid #dee2e6;
}

/* المستويات */
.level-1 {
    background-color: #e3f2fd;
    font-weight: bold;
}

.level-2 {
    background-color: #f1f8ff;
    font-weight: 600;
}

.level-3 {
    background-color: #f8fbff;
}

.level-4 {
    background-color: #fafcff;
}

.level-5 {
    background-color: #fcfdff;
}

/* الفوتر (المجموع) */
.account-table tfoot {
    background-color: #f7a244 !important;
    font-weight: bold;
}

.account-table tfoot td {
    padding: 12px 10px;
    border: 1px solid #dee2e6;
    color: #212529 !important;
}

/* قسم المجموع النهائي */
.totals-section {
    margin-top: 50px;
    border: 2px solid #ff6b35;
    overflow: hidden;
}

.totals-section .account-header {
    background: #ff6b35 !important;
    color: white !important;
}

.totals-section .account-title {
    color: white;
    margin: 0;
}

.text-right {
    text-align: right !important;
}

@media print {
    body {
        padding: 0;
    }
    .pdf-body {
        padding: 10px;
    }
    .account-section {
        page-break-inside: avoid;
        margin-bottom: 30px;
    }
}