<header class="pdf-header" dir="{{ $direction ?? 'rtl' }}">
    <div class="header-container">
        {{-- Left side: date and time --}}
        <div class="header-left">
            <p>Time : {{ now()->format('H:i:s') }}</p>
            <p>Date : {{ now()->format('Y/m/d') }}</p>
        </div>

             {{-- Right side: company info --}}
        <div class="header-right">
            <p>{{ $company_name ?? 'اسم الشركة' }}</p>
            <p>الرقم الضريبي {{ $company_vat ?? '000000000000000' }}</p>
        </div>
        {{-- Center: report title --}}
        <div class="header-center">
            <h2>{{ $type ? $type . " Report" : 'Report Title' }}</h2>
        </div>

   
    </div>

    {{-- ✅ Show account number & branch section only if multiple companies --}}
    @if(isset($companies) && count($companies) > 0)
        <div class="header-extra">
            <table width="100%" cellspacing="0" cellpadding="5">
                <thead>
                    <tr>
                        <th>Branch Name</th>
                        <th>Account Number</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($companies as $company)
                        <tr>
                            <td>{{ $company->name_company }}</td>
                            <td>{{ $company->company_vat }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif

    {{-- Date range --}}
    @if(!empty($date_from) && !empty($date_to))
        <div class="header-dates">
            <p>Date From: {{ $date_from }} :: Date To: {{ $date_to }}</p>
        </div>
    @endif
</header>
