@extends('pdf.layouts.app')
@section('title', 'Bank Statement Report')

@section('styles')
<style>
    @include('css.bank-statement')
</style>
@endsection

@section('content')

@php 
    $ShowByDefault = $ShowByDefault ?? false; 
@endphp

<main class="pdf-body">
    @if(isset($data) && count($data) > 0)
     @foreach($data as $account)
    <section class="account-section">
        <div class="account-header">
            <h3 class="account-title">{{ $account['tree_account_title'] ?? '-' }}</h3>
            <span class="account-serial">{{ __('Serial Number') }}: {{ $account['tree_account_serial_number'] ?? '-' }}</span>
        </div>
    

                {{-- جدول المعاملات --}}
                @if(isset($account['transactions']) && count($account['transactions']) > 0)
                    <table class="account-table">
                        <thead>
                            <tr>
                                <th>{{ __('Date') }}</th>
                                <th>{{ __('Constraint') }}</th>
                                <th>{{ __('Constraint Number') }}</th>
                                <th>{{ __('Cost Center') }}</th>
                                <th>{{ __('Debit') }}</th>
                                <th>{{ __('Credit') }}</th>
                                <th>{{ __('Balance') }}</th>
                                @if(!$ShowByDefault)
                                    <th>{{ __('Currency Transfer Rate') }}</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($account['transactions'] as $transaction)
                                <tr>
                                    <td>{{ $transaction['date'] ?? '-' }}</td>
                                    <td>{{ $transaction['constraint_name'] ?? '-' }}</td>
                                    <td>{{ $transaction['number_doc'] ?? '-' }}</td>
                                    <td>{{ $transaction['cost_center_name'] ?? '-' }}</td>
                                    <td class="debit">{{ number_format($transaction['debit'] ?? 0, 2) }}</td>
                                    <td class="credit">{{ number_format($transaction['credit'] ?? 0, 2) }}</td>
                                    <td>
                                        @php $bal = $transaction['running_balance'] ?? 0; @endphp
                                        <span class="{{ $bal < 0 ? 'negative-value' : '' }}">
                                            {{ number_format($bal, 2) }}
                                        </span>
                                    </td>
                                    @if(!$ShowByDefault)
                                        <td>{{ number_format($transaction['currency_transfer_rate'] ?? 0, 2) }}</td>
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="total-row">
                                <td colspan="{{ $ShowByDefault ? 4 : 5 }}" class="text-right">
                                    <strong>{{ __('Total') }}:</strong>
                                </td>
                                <td class="debit"><strong>{{ number_format($account['total_debit'] ?? 0, 2) }}</strong></td>
                                <td class="credit"><strong>{{ number_format($account['total_credit'] ?? 0, 2) }}</strong></td>
                                <td><strong>
                                    @php $fb = $account['total_balance'] ?? 0; @endphp
                                    <span class="{{ $fb < 0 ? 'negative-value' : '' }}">
                                        {{ number_format($fb, 2) }}
                                    </span>
                                </strong></td>
                                @if(!$ShowByDefault)
                                    <td></td>
                                @endif
                            </tr>
                        </tfoot>
                    </table>
                @else
                    <div class="no-transactions">
                        <p>{{ __('No transactions available for this account') }}</p>
                    </div>
                @endif
            </section>
        @endforeach
    @else
        <div style="padding:20px;text-align:center;background:#fff3cd;border:1px solid #ffc107;border-radius:5px;">
            <p style="margin:0;color:#856404;">{{ __('No data available to display') }}</p>
        </div>
    @endif
</main>

@endsection