@extends('pdf.layouts.app')

@section('title', 'Cost Center Report')

@section('styles')
    <style>
        @include('css.cost_center')
    </style>
@endsection
@section('content')
    <main class="pdf-body">
@if(isset($data) && (is_array($data) || $data instanceof \Illuminate\Support\Collection))
            @foreach($data as $center)
                <section class="cost-center-section">
                    <h3 class="cost-center-title">
                         {{ $center['cost_center_name'] ?? '---' }}
                    </h3>

                    <table class="cost-center-table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Constraint Number</th>
                                <th>Constraint</th>
                                <th>Account</th>
                                <th>Currency</th>
                                <th>Debit</th>
                                <th>Credit</th>
                                <th>Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($center['transactions'] as $row)
                                <tr>
                                    <td>{{ $row['date'] ?? '' }}</td>
                                    <td>{{ $row['number_doc'] ?? '' }}</td>
                                    <td>{{ $row['constraint_name'] ?? '' }}</td>
                                    <td>{{ $row['tree_account_title'] ?? '' }}</td>
                                    <td>{{ $row['currency_name'] ?? '' }}</td>
                                    <td class="debit">{{ number_format($row['debit'] ?? 0, 2) }}</td>
                                    <td class="credit">{{ number_format($row['credit'] ?? 0, 2) }}</td>
                                    <td>{{ number_format($row['balance'] ?? 0, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="total-row">
                                <td colspan="5" class="text-right"><strong>Total:</strong></td>
                                <td class="debit"><strong>{{ number_format($center['total_debit'] ?? 0, 2) }}</strong></td>
                                <td class="credit"><strong>{{ number_format($center['total_credit'] ?? 0, 2) }}</strong></td>
                                <td><strong>{{ number_format($center['total_balance'] ?? 0, 2) }}</strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </section>
            @endforeach
        @else
            <p class="no-data">There is no Cost Center data available.</p>
        @endif
    </main>
@endsection