@extends('pdf.layouts.app')
@section('title', 'Ledger Report')

@section('styles')
<style>
    @include('css.ledger')
</style>
@endsection

@section('content')

@php $ShowByDefault = $ShowByDefault ?? false; @endphp

<main class="pdf-body">
    @if(isset($data) && count($data) > 0)
        @foreach($data as $account)
            <section class="account-section">
                {{-- هيدر الحساب --}}
                <div class="account-header">
                    <h3 class="account-title">{{ $account['tree_account_title'] ?? '-' }}</h3>
                    <span class="account-serial">{{ __('Serial Number') }}: {{ $account['tree_account_serial_number'] ?? '-' }}</span>
                </div>

                {{-- معلومات الحساب الأساسية --}}
                <table class="summary-table">
                    <thead>
                        <tr>
                            <th colspan="3">{{ __('Opening Balance') }}</th>
                            <th colspan="3">{{ __('Period Movements') }}</th>
                            <th rowspan="2">{{ __('Final Balance') }}</th>
                        </tr>
                        <tr>
                            <th>{{ __('Debit') }}</th>
                            <th>{{ __('Credit') }}</th>
                            <th>{{ __('Balance') }}</th>
                            <th>{{ __('Debit') }}</th>
                            <th>{{ __('Credit') }}</th>
                            <th>{{ __('Balance') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ number_format($account['initial_debit'] ?? 0, 2) }}</td>
                            <td>{{ number_format($account['initial_credit'] ?? 0, 2) }}</td>
                            <td>
                                @php $initialBalance = $account['initial_balance'] ?? 0; @endphp
                                <span class="{{ $initialBalance < 0 ? 'negative-value' : '' }}">
                                    {{ number_format($initialBalance, 2) }}
                                </span>
                            </td>
                            <td>{{ number_format($account['period_debit'] ?? 0, 2) }}</td>
                            <td>{{ number_format($account['period_credit'] ?? 0, 2) }}</td>
                            <td>
                                @php $periodBalance = $account['period_balance'] ?? 0; @endphp
                                <span class="{{ $periodBalance < 0 ? 'negative-value' : '' }}">
                                    {{ number_format($periodBalance, 2) }}
                                </span>
                            </td>
                            <td>
                                @php $finalBalance = $account['final_balance'] ?? 0; @endphp
                                <span class="{{ $finalBalance < 0 ? 'negative-value' : '' }}">
                                    {{ number_format($finalBalance, 2) }}
                                </span>
                            </td>
                        </tr>
                    </tbody>
                </table>

                {{-- جدول المعاملات --}}
                @if(isset($account['transactions']) && count($account['transactions']) > 0)
                    <table class="transactions-table">
                        <thead>
                            <tr>
                                <th>{{ __('Date') }}</th>
                                <th>{{ __('Constraint') }}</th>
                                <th>{{ __('Constraint Number') }}</th>
                                <th>{{ __('Cost Center') }}</th>
                                <th>{{ __('Debit') }}</th>
                                <th>{{ __('Credit') }}</th>
                                <th>{{ __('Balance') }}</th>
                                <th>{{ __('Currency') }}</th>
                                @if(!$ShowByDefault)
                                    <th>{{ __('Transfer Rate') }}</th>
                                @endif
                                <th>{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($account['transactions'] as $transaction)
                                <tr>
                                    <td>{{ $transaction['date'] ?? '-' }}</td>
                                    <td>{{ $transaction['constraint_name'] ?? '-' }}</td>
                                    <td>{{ $transaction['number_doc'] ?? '-' }}</td>
                                    <td>{{ $transaction['cost_center_name'] ?? '-' }}</td>
                                    <td class="debit">{{ number_format($transaction['debit'] ?? 0, 2) }}</td>
                                    <td class="credit">{{ number_format($transaction['credit'] ?? 0, 2) }}</td>
                                    <td>
                                        @php $runningBalance = $transaction['running_balance'] ?? 0; @endphp
                                        <span class="{{ $runningBalance < 0 ? 'negative-value' : '' }}">
                                            {{ number_format($runningBalance, 2) }}
                                        </span>
                                    </td>
                                    <td>{{ $transaction['currency_name'] ?? '-' }}</td>
                                    @if(!$ShowByDefault)
                                        <td>{{ number_format($transaction['transfer_rate'] ?? 0, 2) }}</td>
                                    @endif
                                    <td>...</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="no-transactions">
                        <p>{{ __('No transactions available for this account') }}</p>
                    </div>
                @endif
            </section>
        @endforeach
    @else
        <div style="padding:20px;text-align:center;background:#fff3cd;border:1px solid #ffc107;border-radius:5px;">
            <p style="margin:0;color:#856404;">{{ __('No data available to display') }}</p>
        </div>
    @endif
</main>

@endsection