@extends('pdf.layouts.app')


@section('styles')
    <style>
        @include('css.balance-income')
      
    </style>
@endsection

@section('content')
<div class="container" dir="{{ $direction ?? 'rtl' }}">

    <table width="100%" cellspacing="0" cellpadding="5">
        <thead>
            <tr>
                <th>Account No.</th>
                <th>Account Name</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            @php $firstSection = true; @endphp
            @foreach($data as $account)
                @php 
                    if (!$firstSection) {
                        // Add spacer row
                        echo '<tr class="section-spacer"><td colspan="5"></td></tr>';
                        
                        // Add header row
                        echo '<tr class="section-header">';
                        echo '<th>Account No.</th>';
                        echo '<th>Account Name</th>';
                        echo '<th>Debit</th>';
                        echo '<th>Credit</th>';
                        echo '<th>Balance</th>';
                        echo '</tr>';
                    }
                    $firstSection = false;
                    renderAccount($account, 1, true); 
                @endphp
            @endforeach
        </tbody>
    </table>

    <div class="totals" style="margin-top: 20px; text-align: right;">
        <p><strong>Total Balance:</strong> {{ number_format($totals['grand_total_balance'] ?? 0, 2) }}</p>
    </div>
</div>
@endsection

@php
/**
 * Recursive function to render hierarchical accounts.
 */
function renderAccount($account, $level = 1, $isTopLevel = false)
{
    $padding = 20 * ($level - 1);

    echo '<tr class="level-' . min($level, 6) . '">';
    echo '<td>' . e($account['serial_number']) . '</td>';
    echo '<td style="padding-left:' . $padding . 'px;">' . e($account['title']) . '</td>';
    echo '<td>' . number_format($account['total_debit'], 2) . '</td>';
    echo '<td>' . number_format($account['total_creditor'], 2) . '</td>';
    echo '<td>' . number_format($account['balance'], 2) . '</td>';
    echo '</tr>';

    // Render children
    if (!empty($account['children'])) {
        foreach ($account['children'] as $child) {
            renderAccount($child, $level + 1, false);
        }
        
        // Only add subtotal rows for top-level accounts (level 1)
        if ($isTopLevel) {
            // Grand Total row
            echo '<tr class="subtotal-row">';
            echo '<td colspan="2" class="subtotal-label">Grand Total</td>';
            echo '<td>' . number_format($account['total_debit'], 2) . '</td>';
            echo '<td>' . number_format($account['total_creditor'], 2) . '</td>';
            echo '<td>' . number_format($account['balance'], 2) . '</td>';
            echo '</tr>';
            
            // Net Balance row
            echo '<tr class="subtotal-row">';
            echo '<td colspan="4" class="subtotal-label">Net Balance</td>';
            echo '<td>' . number_format($account['balance'], 2) . '</td>';
            echo '</tr>';
        }
    }
}

@endphp