@extends('pdf.layouts.app')

@section('title', 'Daily Journal Report')

@section('styles')
    <style>
        @include('css.daily_report')
    </style>
@endsection

@section('content')
<div class="container" >

    @php
        $transactions = $data['data'] ?? [];
        $summary = $data['summery'] ?? [];

        // default false if backend didn't pass it
        $ShowByDefault = $ShowByDefault ?? false;
    @endphp

    {{-- Transactions Table --}}
    @if(count($transactions) > 0)
        <table width="100%" cellspacing="0" cellpadding="5">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Number</th>
                    <th>Date</th>
                    <th>Account</th>
                    <th>Name</th>
                    <th>Debit</th>
                    <th>Credit</th>

                    @if(!$ShowByDefault)
                        <th>Currency Transfer Rate</th>
                    @endif
                </tr>
            </thead>

            <tbody>
                @foreach($transactions as $index => $item)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $item['constraint_number_doc'] ?? '-' }}</td>
                        <td>
                            {{ isset($item['date']) ? \Carbon\Carbon::parse($item['date'])->format('d/m/Y') : '-' }}
                        </td>
                        <td>{{ $item['account'] ?? '-' }}</td>
                        <td>{{ $item['transfer_name'] ?? '-' }}</td>
                        <td>{{ number_format($item['debit'] ?? 0, 2) }}</td>
                        <td>{{ number_format($item['creditor'] ?? 0, 2) }}</td>

                        @if(!$ShowByDefault)
                            <td>{{ $item['currency_transfer_rate'] ?? '-' }}</td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{-- Summary Section --}}
        <div class="summary">
            <h3>Summary</h3>
            <table>
                <tr>
                    <th>Total Debit</th>
                    <th>Total Credit</th>
                </tr>
                <tr>
                    <td>{{ number_format($summary['total_debit'] ?? 0, 2) }}</td>
                    <td>{{ number_format($summary['total_creditor'] ?? 0, 2) }}</td>
                </tr>
            </table>
        </div>

    @else
        <p style="text-align:center; color:#b71c1c; background:#fff3cd; padding:15px; border-radius:6px;">
            No data available for this report.
        </p>
    @endif

</div>
@endsection
