@extends('pdf.layouts.app')

@section('title', 'General Ledger Report')

@section('styles')
    <style>
        @include('css.trial_balance')
    </style>
@endsection

@section('content')
<main class="pdf-body">
    @if(isset($data['data']) && is_array($data['data']))
        @foreach($data['data'] as $account)
            @php renderAccountSection($account); @endphp
        @endforeach
    @elseif(is_array($data))
        @foreach($data as $account)
            @php renderAccountSection($account); @endphp
        @endforeach
    @endif

    {{-- المجموع النهائي --}}
    <section class="totals-section">
        <div class="account-header">
            <h3 class="account-title">{{ __('Total') }}</h3>
        </div>
        <table class="account-table">
            <thead>
                <tr>
                    <th>{{ __('Description') }}</th>
                    <th>{{ __('Opening Debit') }}</th>
                    <th>{{ __('Opening Credit') }}</th>
                    <th>{{ __('Period Debit') }}</th>
                    <th>{{ __('Period Credit') }}</th>
                    <th>{{ __('Final Debit') }}</th>
                    <th>{{ __('Final Credit') }}</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-right"><strong>{{ __('Total') }}</strong></td>
                    <td>{{ number_format($totals['total_debit_initial'] ?? 0, 2) }}</td>
                    <td>{{ number_format($totals['total_creditor_initial'] ?? 0, 2) }}</td>
                    <td>{{ number_format($totals['total_debit_within'] ?? 0, 2) }}</td>
                    <td>{{ number_format($totals['total_creditor_within'] ?? 0, 2) }}</td>
                    <td>{{ number_format($totals['total_debit'] ?? 0, 2) }}</td>
                    <td>{{ number_format($totals['total_creditor'] ?? 0, 2) }}</td>
                </tr>
                <tr>
                    <td class="text-right"><strong>{{ __('Difference') }}</strong></td>
                    <td colspan="2">{{ number_format(($totals['total_debit_initial'] ?? 0) - ($totals['total_creditor_initial'] ?? 0), 2) }}</td>
                    <td colspan="2">{{ number_format(($totals['total_debit_within'] ?? 0) - ($totals['total_creditor_within'] ?? 0), 2) }}</td>
                    <td colspan="2">{{ number_format(($totals['total_debit'] ?? 0) - ($totals['total_creditor'] ?? 0), 2) }}</td>
                </tr>
            </tbody>
        </table>
    </section>
</main>
@endsection

@php
function renderAccountSection($account)
{
    if (!isset($account['title']) || !isset($account['serial_number'])) return;
    
    $serialNumber = $account['serial_number'] ?? '';
    $hasChildren = !empty($account['children']);
    
    echo '<section class="account-section">';
    
    // هيدر الحساب
    echo '<div class="account-header">';
    echo '<h3 class="account-title">' . e($account['title']) . '</h3>';
    echo '<span class="account-serial">' . __('Serial Number') . ': ' . $serialNumber . '</span>';
    echo '</div>';
    
    // الجدول
    echo '<table class="account-table">';
    echo '<thead><tr>';
    echo '<th>' . __('Account') . '</th>';
    echo '<th>' . __('Serial Number') . '</th>';
    echo '<th>' . __('Opening Debit') . '</th>';
    echo '<th>' . __('Opening Credit') . '</th>';
    echo '<th>' . __('Period Debit') . '</th>';
    echo '<th>' . __('Period Credit') . '</th>';
    echo '<th>' . __('Final Debit') . '</th>';
    echo '<th>' . __('Final Credit') . '</th>';
    echo '</tr></thead>';
    
    echo '<tbody>';
    
    // صف الحساب الرئيسي
    renderAccountRow($account, 1);
    
    // الأطفال
    if ($hasChildren) {
        foreach ($account['children'] as $child) {
            renderAllChildren($child, 2);
        }
    }
    
    echo '</tbody>';
    
    // المجموع
    echo '<tfoot><tr class="total-row">';
    echo '<td colspan="2" class="text-right"><strong>' . __('Total') . '</strong></td>';
    echo '<td><strong>' . number_format($account['total_debit_initial'] ?? 0, 2) . '</strong></td>';
    echo '<td><strong>' . number_format($account['total_creditor_initial'] ?? 0, 2) . '</strong></td>';
    echo '<td><strong>' . number_format($account['total_debit_within'] ?? 0, 2) . '</strong></td>';
    echo '<td><strong>' . number_format($account['total_creditor_within'] ?? 0, 2) . '</strong></td>';
    echo '<td><strong>' . number_format($account['total_debit'] ?? 0, 2) . '</strong></td>';
    echo '<td><strong>' . number_format($account['total_creditor'] ?? 0, 2) . '</strong></td>';
    echo '</tr></tfoot>';
    
    echo '</table>';
    echo '</section>';
}

function renderAllChildren($account, $level)
{
    renderAccountRow($account, $level);
    
    if (!empty($account['children'])) {
        foreach ($account['children'] as $child) {
            renderAllChildren($child, $level + 1);
        }
    }
}

function renderAccountRow($account, $level)
{
    $indent = ($level - 1) * 20;
    
    echo '<tr class="level-' . $level . '">';
    echo '<td style="padding-right: ' . $indent . 'px;">' . e($account['title']) . '</td>';
    echo '<td>' . ($account['serial_number'] ?? '') . '</td>';
    echo '<td>' . number_format($account['total_debit_initial'] ?? 0, 2) . '</td>';
    echo '<td>' . number_format($account['total_creditor_initial'] ?? 0, 2) . '</td>';
    echo '<td>' . number_format($account['total_debit_within'] ?? 0, 2) . '</td>';
    echo '<td>' . number_format($account['total_creditor_within'] ?? 0, 2) . '</td>';
    echo '<td>' . number_format($account['total_debit'] ?? 0, 2) . '</td>';
    echo '<td>' . number_format($account['total_creditor'] ?? 0, 2) . '</td>';
    echo '</tr>';
}
@endphp