<!DOCTYPE html>
<html lang="{{ $direction === 'rtl' ? 'ar' : 'en' }}" dir="{{ $direction }}">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Cash Receipt Voucher</title>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap');

        body {
            font-family: 'Cairo', Arial, sans-serif;
            margin: 40px;
            background: #fff;
            font-size: 14px;
        }

        body.rtl {
            direction: rtl;
        }
        
        body.ltr {
            direction: ltr;
        }

        .receipt {
            border: 1px solid #000;
            padding: 20px;
            max-width: 900px;
            margin: auto;
            position: relative;
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        body.rtl .header {
            flex-direction: row-reverse;
        }

        .logo { 
            height: 70px;
            object-fit: contain;
        }

        .header-center {
            flex: 1;
            text-align: center;
        }

        .header-side {
            min-width: 200px;
        }

        body.rtl .header-side {
            text-align: left;
        }

        body.ltr .header-side {
            text-align: right;
        }

        /* Tables */
        .details-table, .footer-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .details-table td,
        .footer-table td,
        .footer-table th {
            border: 1px solid #000;
            padding: 8px;
            vertical-align: middle;
        }

        body.rtl .details-table td,
        body.rtl .footer-table td,
        body.rtl .footer-table th {
            text-align: right;
        }

        body.ltr .details-table td,
        body.ltr .footer-table td,
        body.ltr .footer-table th {
            text-align: left;
        }

        /* Signature Section */
        .signature {
            margin-top: 25px;
            display: flex;
            justify-content: space-between;
        }

        body.rtl .signature {
            flex-direction: row-reverse;
        }

        .signature > div { 
            width: 45%;
        }

        .small { 
            font-size: 12px;
        }

        .signature-line {
            margin: 5px 0;
        }

        .text-center {
            text-align: center;
        }

        /* Timestamp */
        .timestamp {
            font-size: 12px;
            margin-top: 10px;
        }

        body.rtl .timestamp {
            text-align: left;
        }

        body.ltr .timestamp {
            text-align: right;
        }
    </style>
</head>

<body class="{{ $direction }}">
<div class="receipt">

    <!-- Header -->
    <div class="header">
        <img src="https://images.seeklogo.com/logo-png/42/1/corporate-company-logo-png_seeklogo-425925.png" 
             class="logo" 
             alt="Company Logo" />

        <div class="header-center">
            <strong>{{ $voucher_type }} #</strong><br>
            {{ $number_doc }}
        </div>

        <div class="header-side">
            <strong>{{ $company['name_company'] }}</strong><br>
            VAT: {{ $company['company_vat'] ?? '---' }}
        </div>
    </div>

    <!-- Details Table -->
    <table class="details-table">
        <tr>
            <td>Safe:</td>
            <td colspan="3">{{ $name ?? '---' }}</td>
            <td>Date:</td>
            <td>{{ $date }}</td>
        </tr>

        <tr>
            <td>Amount:</td>
            <td>
                {{ number_format($credit_account['credit_amount'], 2) }}
          EGP
            </td>

            <td>Exchange Rate:</td>
            <td>{{ $currency_transfer_rate ?? 1 }}</td>

            <td>Total Amount:</td>
            <td>
                {{ number_format(($credit_account['credit_amount'] ?? 0) * ($currency_transfer_rate ?? 1), 2) }}
                {{ $credit_account['base_currency_symbol'] ?? 'EGP' }}
            </td>
        </tr>

        <tr>
            <td>Received From:</td>
            <td colspan="5">{{ $user['name'] ?? '---' }}</td>
        </tr>

        <tr>
            <td>Details:</td>
            <td colspan="5">{{ $description }}</td>
        </tr>

        <tr>
            <td>Amount in words:</td>
            <td colspan="5">{{ $credit_account['amount_in_words'] }}</td>
        </tr>
    </table>

    <!-- Signature Section -->
    <div class="signature">
        <div>
            <p class="small">Approved by</p>
            <p class="signature-line">...................................................</p>

            <p class="small">Created by</p>
            <p class="signature-line">...................................................</p>
        </div>

        <div>
            <p class="text-center">Recipient</p>
            <p class="small">Name</p>
            <p class="signature-line">...................................................</p>
            <p class="small">Signature</p>
            <p class="signature-line">...................................................</p>
        </div>
    </div>

    <!-- Timestamp -->
    <p class="timestamp">{{ now()->format('Y-m-d H:i') }}</p>

    <!-- Footer Table -->
    <table class="footer-table">
        <tr>
            <th>Account No.</th>
            <th>Reference No.</th>  
            <th>Notes</th>
            <th>Tour File</th>
            <th>Amount</th>
        </tr>
        <tr>
            <td>{{ $credit_account['account_title'] ?? '---' }}</td>
            <td>-</td>
            <td>Settlement of Advance Payment</td>
            <td>-</td>
            <td>{{ number_format($credit_account['credit_amount'] ?? 0, 2) }}</td>
        </tr>
    </table>

</div>
</body>
</html>