<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accounting\ConstraintCollection;
use App\Http\Resources\Accounting\ConstraintResource;
use App\Models\Languages\Languages;
use App\sys\ApiResponse;
use App\sys\Services\Accounting\ConstraintService;
use PDF;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ConstraintController extends Controller
{
    use ApiResponse;

    protected ConstraintService $service;

    public function __construct(ConstraintService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        $constraints = $this->service->getPaginated();

        return $this->apiResponse(200, 'success', null, new ConstraintCollection($constraints));
    }

    public function show($id)
    {
        $item = $this->service->getById((int) $id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        $item->load(['transfers', 'attachments']);

        return $this->apiResponse(200, 'success', null, new ConstraintResource($item));
    }


  public function getConstriantByid ($constraint_id)
    {
      
        $result =  $this->service->getConstriantByid($constraint_id);
        
        if (!$result['success']) {
            return response()->json([
                'status' => false,
                'errors' => $result['errors']
            ], 422);
        }

        return response()->json([
            'status' => true,
            'data' => $result['data']
        ], 200);
    }


//To Print The Pdf 
public function print($constraint_id)
{
    if ($data = $this->service->print($constraint_id)) {
        
        $data = $data['data'];
        
        $viewType = request()->query('view');
      
        $direction = config('app.direction', 'ltr'); 
        $data['direction'] = $direction;
        $pdf = PDF::loadView('pdf.voucher', $data, [], array_merge(
        config('pdf_custom.mpdf'),
        ['directionality' => $direction]
));
        switch ($viewType) {
            case 'html':
                return view('pdf.voucher', $data);

            case 'pdf':
                return $pdf->stream("voucher_{$constraint_id}.pdf");

            case 'download':
                return $pdf->download("voucher_{$constraint_id}.pdf");

            default:
                return $pdf->stream("voucher_{$constraint_id}.pdf");
        }
    }

    return $this->apiResponse(400, 'false', $this->service->errors(), null);
}




    public function store(Request $request)
    {
        $response = $this->service->create($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new ConstraintResource($response));
    }

    public function update(Request $request)
    {
        $response = $this->service->update($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new ConstraintResource($response));
    }

    public function destroy(Request $request)
    {
        $response = $this->service->del($request->ids);
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'Constraint deleted successfully', null);
    }

    public function deleteAttachments(Request $request)
    {
        $result = $this->service->deleteAttachments($request->all());
        if (! $result) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getNextDocumentNumber($type)
    {
        $number = $this->service->getNextDocumentNumber($type);

        return $this->apiResponse(200, 'success', null, ['next_document_number' => $number]);
    }

    public function activate($id)
    {
        $updated = $this->service->activate((int)$id);
        if (! $updated) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new ConstraintResource($updated));
    }
}
