<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\TransportationModes\TransportationModesLangResource;
use App\Http\Resources\General\TransportationModesHistoryResource;
use App\Http\Resources\TransportationModesCollection;
use App\Http\Resources\TransportationModesResource;
use App\sys\ApiResponse;
use App\sys\Services\General\TransportationModesService;
use App\sys\Services\General\TransportationModesTranslationService;
use Illuminate\Http\Request;

class TransportationModesController extends Controller
{
    use ApiResponse;

    private $service;

    private $translationService;

    public function __construct()
    {
        $this->service = new TransportationModesService;
        $this->translationService = new TransportationModesTranslationService;
    }

    public function create(Request $request)
    {
        if ($item = $this->service->create($request->all())) {
            $collect = new TransportationModesResource($item);

            return $this->apiResponse(200, 'Transportation Mode created successfully', null, $collect);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'Error creating Transportation Mode', $errors, null);
    }

    public function update(Request $request)
    {
        if ($item = $this->service->update($request->all())) {
            $collect = new TransportationModesResource($item);

            return $this->apiResponse(200, 'Transportation Mode updated successfully', null, $collect);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'Error updating Transportation Mode', $errors, null);
    }

    public function index()
    {
        $data = $this->service->index();
        $collect = new TransportationModesCollection($data);

        return $this->apiResponse(200, 'Transportation Modes retrieved successfully', null, $collect);
    }

    public function getById($id)
    {
        if ($data = $this->service->getById($id)) {
            $collect = new TransportationModesResource($data);

            return $this->apiResponse(200, 'Transportation Mode retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Transportation Mode not found', ['not found'], null);
    }

    public function getActive()
    {
        $data = $this->service->getActive();
        $collect = new TransportationModesCollection($data);

        return $this->apiResponse(200, 'Active Transportation Modes retrieved successfully', null, $collect);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->service->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Transportation Modes deleted successfully', null, null);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->translationService->saveTranslation($request->all(), $id)) {
            $errors = $this->translationService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        $data = $this->service->getWithTranslation($id);
        $collection = new TransportationModesLangResource($data);

        return $this->apiResponse(200, 'success', null, $collection);
    }

    public function delLang($id)
    {
        if ($this->translationService->delLang($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }
        $errors = $this->translationService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $item = $this->service->getById($id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        $changes = $this->service->getAllChanges($item);

        return $this->apiResponse(200, 'success', null, TransportationModesHistoryResource::collection($changes));
    }
}
