<?php

namespace App\Http\Resources\Invoice;

use App\sys\Services\Invoice\InvoiceServicesTypeConfig;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InvoiceServicesResource extends JsonResource
{
    protected $serviceType;

    public function __construct($resource, ?string $serviceType = null)
    {
        parent::__construct($resource);
        $this->serviceType = $serviceType ?? $resource->travel_tourism_type ?? 'accommodation';
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $resourceFields = InvoiceServicesTypeConfig::getResourceFields($this->serviceType);
        $relationships = InvoiceServicesTypeConfig::getRelationships($this->serviceType);

        $data = [];

        // Add basic fields (include even if null)
        foreach ($resourceFields as $field) {
            $data[$field] = $this->$field;
        }

        // Add relationships
        foreach ($relationships as $relationship) {
            if ($this->relationLoaded($relationship)) {
                $data[$relationship] = $this->whenLoaded($relationship);
            }
        }

        return $data;
    }
}
