<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class CustomerResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'nationality_id' => $this->nationality_id,
            'country_id' => $this->country_id,
            'passport' => $this->passport,
            'company_id' => $this->company_id,
            'user_id' => $this->user_id,
            'character_status' => $this->character_status,
            'notes' => $this->notes,
            'type' => $this->type,
            'active' => (bool) $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'nationality' => $this->relationLoaded('nationality') && $this->nationality ? [
                'id' => $this->nationality->id,
                'name' => $this->nationality->relationLoaded('currentTranslation')
                    ? ($this->nationality->currentTranslation->name ?? $this->nationality->name)
                    : $this->nationality->name,
            ] : null,
            'country' => $this->relationLoaded('country') && $this->country ? [
                'id' => $this->country->id,
                'name' => $this->country->relationLoaded('currentTranslation')
                    ? ($this->country->currentTranslation->name ?? $this->country->name)
                    : $this->country->name,
                'code' => $this->country->code,
            ] : null,
            'company' => $this->relationLoaded('company') && $this->company ? [
                'id' => $this->company->id,
                'name' => $this->company->name_company,
            ] : null,
            'user' => $this->relationLoaded('user') && $this->user ? [
                'id' => $this->user->id,
                'name' => $this->user->name,
                'email' => $this->user->email,
            ] : null,
        ];
    }
}
