<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceTypeResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'type_label' => $this->getTypeLabel(),
            'title' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'item_code' => $this->item_code,
            'unit_type' => $this->unit_type,
            'is_active' => $this->is_active,
            'services_count' => $this->when(isset($this->services_count), $this->services_count),
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }

    protected function getTypeLabel()
    {
        $labels = [
            'additional_services' => 'خدمات أخرى',
            'tour_guide' => 'الدليل السياحي',
            'daily_itinerary' => 'البرنامج اليومي',
            'entrance_tickets' => 'تذاكر دخول',
            'tour_reps' => 'مناديب',
            'dining_entertainment' => 'مطاعم وسهرات',
            'temples' => 'معابد',
            'attractions' => 'مزارات',
        ];

        return $labels[$this->type] ?? $this->type;
    }
}
