<?php

namespace App\Models\Accommodation;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Extra extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'ac_extras';

    protected $fillable = [
        'name',
    ];

    public function translations()
    {
        return $this->hasMany(EXtrasTranslations::class, 'extras_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(EXtrasTranslations::class, 'extras_id')
            ->where('lang_id', app('lang_id'));
    }
}
