<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Restaurant extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'ge_restaurant';

    protected $fillable = [
        'name',
        'is_active',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'name',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(RestaurantTranslation::class, 'restaurant_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(RestaurantTranslation::class, 'restaurant_id')
            ->where('lang_id', app('lang_id'));
    }
}
