<?php

namespace App\Models\Profile;

use App\Models\Accommodation\MealPlans;
use App\Models\Accommodation\RoomTypes;
use App\Models\Accommodation\RoomViews;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class AccommodationReservationRoom extends Model implements Auditable
{
    use AuditableTrait;

    protected $table = 'pr_accommodation_reservation_rooms';

    protected $fillable = [
        'profile_id',
        'nationality_id',
        'reservation_id',
        'check_in',
        'check_out',
        'nights_count',
        'adult_count',
        'childreen_count',
        'no_fee_children_count',
        'room_number',
        'booking_date',
        'meal_plan_id',
        'bed_type',
        'room_type_id',
        'room_view_id',
        'extra_bed',
        'currency_id',
        'total_amount',
        'child_price',
        'adult_price',
        'extra_bed_price',
        'commission',
        'tax_rate_id',
        'tax_rate_price',
        'per_night_price',
        'discount',
        'discount_type',  // 'value','percentage'
        'reservation_date',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'check_in',
        'check_out',
        'nights_count',
        'adult_count',
        'childreen_count',
        'no_fee_children_count',
        'room_number',
        'booking_date',
        'meal_plan_id',
        'bed_type',
        'room_type_id',
        'room_view_id',
        'extra_bed',
        'currency_id',
        'total_amount',
        'child_price',
        'adult_price',
        'extra_bed_price',
        'commission',
        'tax_rate_id',
        'tax_rate_price',
        'per_night_price',
        'discount',
        'discount_type',
        'reservation_date',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function reservation()
    {
        return $this->belongsTo('App\Models\Profile\AccommodationReservation', 'reservation_id');
    }

    public function profile()
    {
        return $this->belongsTo('App\Models\Profile\Profile', 'profile_id');
    }

    public function taxRate()
    {
        return $this->hasMany('App\Models\Profile\AccommodationReservationRoomTax', 'accommodation_reservation_rooms_id')->with('tax');
    }

    public function mealPlan()
    {
        return $this->belongsTo(MealPlans::class, 'meal_plan_id');
    }

    public function roomType()
    {
        return $this->belongsTo(RoomTypes::class, 'room_type_id');
    }

    public function roomView()
    {
        return $this->belongsTo(RoomViews::class, 'room_view_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\\Models\\General\\Currency', 'currency_id');
    }

    public function nationality()
    {
        return $this->belongsTo('App\\Models\\General\\Nationality', 'nationality_id');
    }
}
