<?php

namespace App\Rules;

class CompanyValidationRules
{
    public static function validateData($id = null)
    {
        return [
            'id' => ['nullable', 'integer', 'exists:companies,id'],
            'name' => ['required', 'string', 'max:250', 'unique:companies,name'],
            'companie_address' => ['required', 'string', 'max:200'],
            'companie_state' => ['required', 'string', 'max:100'],
            'companie_city' => ['required', 'string', 'max:100'],
            'companie_zip' => ['required', 'integer'],
            'company_vat' => ['required', 'string', 'max:255'],
            'companie_country' => ['nullable', 'string', 'max:100'],
            'companie_phone' => ['nullable', 'string', 'max:30'],
            'companie_fax' => ['nullable', 'string', 'max:30'],
            'companie_mobile' => ['nullable', 'string', 'max:30'],
            'companie_email' => ['nullable', 'string', 'max:100'],
            'invoice_logo' => ['required', 'regex:/^data:image\/(png|jpg|jpeg);base64,/'],
            'image_stamp_docs' => ['nullable', 'regex:/^data:image\/(png|jpg|jpeg);base64,/'],
            'image_stamp_docs_x' => ['nullable', 'string', 'max:5'],
            'image_stamp_docs_y' => ['nullable', 'string', 'max:5'],
            'image_stamp_docs_size' => ['nullable', 'string', 'max:5'],
            'apear_stamp' => ['nullable', 'integer'],
            'default_invoice_footer' => ['nullable', 'string'],
            // 'fund_account' => ['required', 'integer'],
            // /  'fund_account_cash' => ['required', 'integer'],
            // 'bank_tree_account' => ['required', 'integer'],
            //  'fund_hr' => ['required', 'integer'],
            // 'deposit' => ['required', 'integer'],
            // 'cach_custmer' => ['required', 'integer'],
            // 'fund_hr_cash' => ['required', 'integer'],
            //  'cost_center_id' => ['required', 'integer'],
            // 'cost_center_id_cr' => ['required', 'integer'],
            'issuer_type' => ['nullable', 'in:B,P,F'],
            'issuer_id' => ['nullable', 'string', 'max:100'],
            'issuer_name' => ['nullable', 'string', 'max:100'],
            'issuer_branch_id' => ['nullable', 'integer'],
            'issuer_country' => ['nullable', 'string', 'max:10'],
            'issuer_governate' => ['nullable', 'string', 'max:255'],
            'issuer_region_city' => ['nullable', 'string', 'max:100'],
            'issuer_region_street' => ['nullable', 'string', 'max:255'],
            'issuer_building_number' => ['nullable', 'string', 'max:50'],
            'issuer_postal_code' => ['nullable', 'string', 'max:20'],
            'issuer_floor' => ['nullable', 'string', 'max:255'],
            'issuer_room' => ['nullable', 'string', 'max:255'],
            'issuer_landmark' => ['nullable', 'string', 'max:255'],
            'issuer_additional_information' => ['nullable', 'string', 'max:255'],
            'customers_payments' => ['nullable', 'integer'],
            'active' => ['required', 'in:0,1'],
            'accounting' => ['required', 'array'],
        ];
    }
}
