<?php

namespace App\sys\Repository\General;

use App\Models\General\CityTranslation;

class CityTranslationRepository
{
    private $cityTranslation;

    public function __construct()
    {
        $this->cityTranslation = new CityTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new CityTranslation;
        $rt->city_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->cityTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->cityTranslation->with('getLang')->where('city_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->cityTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
