<?php

namespace App\sys\Repository\General;

use App\Models\General\NationalityTranslation;

class NationalityTranslationRepository
{
    private $nationalityTranslation;

    public function __construct()
    {
        $this->nationalityTranslation = new NationalityTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new NationalityTranslation;
        $rt->nationality_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->nationalityTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->nationalityTranslation->with('getLang')->where('nationality_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->nationalityTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
