<?php

namespace App\sys\Repository\Languages;

use App\Models\Languages\Languages;

class LanguagesRepository
{
    private $lang;

    private $columns = [
        'id' => 'id',
        'name' => 'name',
        'active' => 'is_active',
        'rtl' => 'rtl',
        'code' => 'code',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
    ];

    public function __construct()
    {
        $this->lang = new Languages;
    }

    public function add($data)
    {
        $this->lang->name = $data['name'];
        $this->lang->is_active = $data['active'];
        $this->lang->rtl = $data['rtl'];
        $this->lang->code = $data['code'];
        $this->lang->save();

        return $this->lang;
    }

    public function updated($data)
    {
        $lan = $this->lang->find($data['id']);
        $lan->name = $data['name'] ?? $lan->name;
        $lan->is_active = $data['active'] ?? $lan->is_active;
        $lan->rtl = $data['rtl'] ?? $lan->rtl;
        $lan->code = $data['code'] ?? $lan->code;
        $lan->save();

        return $lan;
    }

    public function gets()
    {
        $column = request('sort_by', null);
        $order = request('sort_order', 'asc');
        $name = request('name', null);
        $limit = request('limit', 15);

        return $this->lang->when('name', function ($query) use ($name) {
            $query->where('name', 'like', '%'.$name.'%');
        })->when($column, function ($query) use ($column, $order) {
            if (array_key_exists($column, $this->columns)) {
                $query->orderBy($this->columns[$column], $order);
            }
        })->paginate($limit);
    }

    public function getById($id)
    {
        return $this->lang->find($id);
    }

    public function getActive()
    {
        return $this->lang->where('is_active', 1)->get();
    }
}
